// Options.cpp : implementation file
//

#include "stdafx.h"
#include "FSDIndexer.h"
#include "Options.h"
#include "xmlreader.h"
#include "tools.h"

// COptions dialog

IMPLEMENT_DYNAMIC(COptions, CDialog)

COptions::COptions(CWnd* pParent /*=NULL*/)
	: CDialog(COptions::IDD, pParent)
	, m_OpenVia(0)
	, m_IPAddress(0)
	, m_Username(L"xbox")
	, m_Password(L"xbox")
	, m_Port(0)
	, m_XBoxDrive(0)
	, m_USBDrive(_T(""))
{
}

COptions::~COptions()
{
}

BOOL COptions::OnInitDialog() 
{
   CDialog::OnInitDialog();
 
   LoadSettings();

   return TRUE;   // return TRUE unless you set the focus to a control
                  // EXCEPTION: OCX Property Pages should return FALSE
}

void COptions::LoadSettings()
{
	XMLReader * xml = LoadConfigFile(L"config.xml");

	m_Username = L"xbox";
	m_Password = L"xbox";
	m_Port = 21;
	m_OpenVia = 1;
	m_XBoxDrive = 0;
	m_IPAddress = inet_addr("192.168.1.100");
	m_IPAddress = htonl(m_IPAddress);

	wstring drive = L"";

	while (xml && xml->read())
	{
		if (StartAttribute(xml,L"openvia"))
		{
			wstring value = xml->getSubNodeData();
			if (value == L"ftp")
			{
				m_OpenVia = 0;
				OnSetFTP();
				//m_OpenViaFTP.SetCheck(BST_CHECKED);
				//m_OpenViaUSB.SetCheck(BST_UNCHECKED);
			} else {
				m_OpenVia = 1;
				OnSetUSB();
				//m_OpenViaFTP.SetCheck(BST_UNCHECKED);
				//m_OpenViaUSB.SetCheck(BST_CHECKED);
			}
		}
		if (StartAttribute(xml,L"username"))
			m_Username = xml->getSubNodeData().c_str();
		if (StartAttribute(xml,L"password"))
			m_Password = xml->getSubNodeData().c_str();
		if (StartAttribute(xml,L"port"))
			m_Port = _wtoi(xml->getSubNodeData().c_str());
		if (StartAttribute(xml,L"hostname"))
		{
			wstring addy = xml->getSubNodeData();
			m_IPAddress = inet_addr(wstrtostr(addy).c_str());
			m_IPAddress = htonl(m_IPAddress);
		}

		if (StartAttribute(xml,L"xboxdrive"))
		{
			wstring value = xml->getSubNodeData();
			if (value == L"usb")
				m_XBoxDrive = 0;
			else
				m_XBoxDrive = 1;
		}
	}

	vector <DriveInfo> drives;
	GetDriveList(drives);
	UpdateData(false);

	vector <DriveInfo>::iterator itr;
	for (itr = drives.begin() ; itr != drives.end() ; itr++)
	{
		DriveInfo info = (*itr);
		wstring display = info.letter + L" - " + info.desc;
		m_USBCombo.AddString(display.c_str());
	}

}

void COptions::SaveSettings()
{
	UpdateData(true);
	string result = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
	result.append("<options>\n");
	if (m_OpenVia == 0)
		result.append("\t<openvia>ftp</openvia>\n");
	else
		result.append("\t<openvia>usb</openvia>\n");
	result.append(sprintfaA("\t<username>%S</username>\n",m_Username.GetString()));
	result.append(sprintfaA("\t<password>%S</password>\n",m_Password.GetString()));
	in_addr in;
	in.S_un.S_addr = htonl(m_IPAddress);
	ftphost = strtowstr(inet_ntoa(in));
	result.append(sprintfaA("\t<hostname>%S</hostname>\n",ftphost.c_str()));
	result.append(sprintfaA("\t<port>%d</port>\n",m_Port));
	if (m_XBoxDrive == 0)
		result.append("\t<xboxdrive>usb</xboxdrive>\n");
	else
		result.append("\t<xboxdrive>hdd</xboxdrive>\n");
	result.append("</options>\n");

	StringToFileA(result,"config.xml");
}

void COptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Radio(pDX, IDC_RADIO1, m_OpenVia);
	DDX_IPAddress(pDX, IDC_IPADDRESS1, m_IPAddress);
	DDX_Text(pDX, IDC_EDIT3, m_Username);
	DDX_Text(pDX, IDC_EDIT1, m_Password);
	DDX_Text(pDX, IDC_EDIT2, m_Port);
	DDV_MinMaxInt(pDX, m_Port, 1, 65535);
	DDX_Radio(pDX, IDC_RADIO3, m_XBoxDrive);
	DDX_CBString(pDX, IDC_COMBO1, m_USBDrive);
	DDX_Control(pDX, IDC_COMBO1, m_USBCombo);
	DDX_Control(pDX, IDC_IPADDRESS1, c_IP);
	DDX_Control(pDX, IDC_EDIT3, c_Username);
	DDX_Control(pDX, IDC_EDIT1, c_Password);
	DDX_Control(pDX, IDC_EDIT2, c_Port);
	DDX_Control(pDX, IDC_RADIO3, c_XDU);
	DDX_Control(pDX, IDC_RADIO4, c_XDH);
}


BEGIN_MESSAGE_MAP(COptions, CDialog)
	ON_BN_CLICKED(IDOK, &COptions::OnBnClickedOk)
	ON_BN_CLICKED(IDC_RADIO1, &COptions::OnSetFTP)
	ON_BN_CLICKED(IDC_RADIO2, &COptions::OnSetUSB)
END_MESSAGE_MAP()


// COptions message handlers

void COptions::OnBnClickedOk()
{
	SaveSettings();
	// TODO: Add your control notification handler code here
	OnOK();
}

void COptions::OnSetFTP()
{
	c_IP.EnableWindow(true);
	c_Username.EnableWindow(true);
	c_Password.EnableWindow(true);
	c_IP.EnableWindow(true);
	c_Port.EnableWindow(true);
	c_XDU.EnableWindow(true);
	c_XDH.EnableWindow(true);
	m_USBCombo.EnableWindow(false);
	int k = 0;
	// TODO: Add your control notification handler code here
}

void COptions::OnSetUSB()
{
	c_IP.EnableWindow(false);
	c_Username.EnableWindow(false);
	c_Password.EnableWindow(false);
	c_IP.EnableWindow(false);
	c_Port.EnableWindow(false);
	c_XDU.EnableWindow(false);
	c_XDH.EnableWindow(false);
	m_USBCombo.EnableWindow(true);
	int k = 0;
	// TODO: Add your control notification handler code here
}
